@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.ListAgentPoolQueueStatusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property agentPoolName The name of the agent pool.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 */
public data class ListAgentPoolQueueStatusPlainArgs(
    public val agentPoolName: String,
    public val registryName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.ListAgentPoolQueueStatusPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.ListAgentPoolQueueStatusPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.ListAgentPoolQueueStatusPlainArgs.builder()
            .agentPoolName(agentPoolName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListAgentPoolQueueStatusPlainArgs].
 */
@PulumiTagMarker
public class ListAgentPoolQueueStatusPlainArgsBuilder internal constructor() {
    private var agentPoolName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the agent pool.
     */
    @JvmName("vkwfwbfymrblqatp")
    public suspend fun agentPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.agentPoolName = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("qrkqwepamnlrnsnj")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("wuoiwgfnejmttucw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListAgentPoolQueueStatusPlainArgs = ListAgentPoolQueueStatusPlainArgs(
        agentPoolName = agentPoolName ?: throw PulumiNullFieldException("agentPoolName"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
