@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.ListWebhookEventsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property webhookName The name of the webhook.
 */
public data class ListWebhookEventsPlainArgs(
    public val registryName: String,
    public val resourceGroupName: String,
    public val webhookName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.ListWebhookEventsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.ListWebhookEventsPlainArgs = com.pulumi.azurenative.containerregistry.inputs.ListWebhookEventsPlainArgs.builder()
        .registryName(registryName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
        .webhookName(webhookName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWebhookEventsPlainArgs].
 */
@PulumiTagMarker
public class ListWebhookEventsPlainArgsBuilder internal constructor() {
    private var registryName: String? = null

    private var resourceGroupName: String? = null

    private var webhookName: String? = null

    /**
     * @param value The name of the container registry.
     */
    @JvmName("vwkjnvqeruekcsbi")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kmiadjgdroacnhbe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the webhook.
     */
    @JvmName("mqpojpmkyrasfoco")
    public suspend fun webhookName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.webhookName = mapped
    }

    internal fun build(): ListWebhookEventsPlainArgs = ListWebhookEventsPlainArgs(
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        webhookName = webhookName ?: throw PulumiNullFieldException("webhookName"),
    )
}
