@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.PipelineRunSourcePropertiesArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.PipelineRunSourceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the source.
 * @property type The type of the source.
 */
public data class PipelineRunSourcePropertiesArgs(
    public val name: Output<String>? = null,
    public val type: Output<Either<String, PipelineRunSourceType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.PipelineRunSourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.PipelineRunSourcePropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.PipelineRunSourcePropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipelineRunSourcePropertiesArgs].
 */
@PulumiTagMarker
public class PipelineRunSourcePropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, PipelineRunSourceType>>? = null

    /**
     * @param value The name of the source.
     */
    @JvmName("wgvvwojhcnwbmatx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of the source.
     */
    @JvmName("xyaueppmiljwvcjn")
    public suspend fun type(`value`: Output<Either<String, PipelineRunSourceType>>) {
        this.type = value
    }

    /**
     * @param value The name of the source.
     */
    @JvmName("huxioiroarcubitn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of the source.
     */
    @JvmName("brxrmrhvausvoejt")
    public suspend fun type(`value`: Either<String, PipelineRunSourceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the source.
     */
    @JvmName("qqhsvyqgxsjfutho")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PipelineRunSourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of the source.
     */
    @JvmName("jhydpeqxhfcsdcbq")
    public fun type(`value`: PipelineRunSourceType) {
        val toBeMapped = Either.ofRight<String, PipelineRunSourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PipelineRunSourcePropertiesArgs = PipelineRunSourcePropertiesArgs(
        name = name,
        type = type,
    )
}
