@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.PipelineTriggerPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sourceTrigger The source trigger properties of the pipeline.
 */
public data class PipelineTriggerPropertiesArgs(
    public val sourceTrigger: Output<PipelineSourceTriggerPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.PipelineTriggerPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.PipelineTriggerPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.PipelineTriggerPropertiesArgs.builder()
            .sourceTrigger(sourceTrigger?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PipelineTriggerPropertiesArgs].
 */
@PulumiTagMarker
public class PipelineTriggerPropertiesArgsBuilder internal constructor() {
    private var sourceTrigger: Output<PipelineSourceTriggerPropertiesArgs>? = null

    /**
     * @param value The source trigger properties of the pipeline.
     */
    @JvmName("jgdywdsuhgsyyivc")
    public suspend fun sourceTrigger(`value`: Output<PipelineSourceTriggerPropertiesArgs>) {
        this.sourceTrigger = value
    }

    /**
     * @param value The source trigger properties of the pipeline.
     */
    @JvmName("vvhjtkdgblxkwjof")
    public suspend fun sourceTrigger(`value`: PipelineSourceTriggerPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceTrigger = mapped
    }

    /**
     * @param argument The source trigger properties of the pipeline.
     */
    @JvmName("uedomuyfonitqtka")
    public suspend fun sourceTrigger(argument: suspend PipelineSourceTriggerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PipelineSourceTriggerPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceTrigger = mapped
    }

    internal fun build(): PipelineTriggerPropertiesArgs = PipelineTriggerPropertiesArgs(
        sourceTrigger = sourceTrigger,
    )
}
