@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.SourceTriggerArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.SourceTriggerEvent
import com.pulumi.azurenative.containerregistry.kotlin.enums.TriggerStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of a source based trigger.
 * @property name The name of the trigger.
 * @property sourceRepository The properties that describes the source(code) for the task.
 * @property sourceTriggerEvents The source event corresponding to the trigger.
 * @property status The current status of trigger.
 */
public data class SourceTriggerArgs(
    public val name: Output<String>,
    public val sourceRepository: Output<SourcePropertiesArgs>,
    public val sourceTriggerEvents: Output<List<Either<String, SourceTriggerEvent>>>,
    public val status: Output<Either<String, TriggerStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.SourceTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.SourceTriggerArgs =
        com.pulumi.azurenative.containerregistry.inputs.SourceTriggerArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .sourceRepository(sourceRepository.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceTriggerEvents(
                sourceTriggerEvents.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SourceTriggerArgs].
 */
@PulumiTagMarker
public class SourceTriggerArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sourceRepository: Output<SourcePropertiesArgs>? = null

    private var sourceTriggerEvents: Output<List<Either<String, SourceTriggerEvent>>>? = null

    private var status: Output<Either<String, TriggerStatus>>? = null

    /**
     * @param value The name of the trigger.
     */
    @JvmName("spgkehqcxshdhorj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The properties that describes the source(code) for the task.
     */
    @JvmName("wxamgbhxlnqqnlbu")
    public suspend fun sourceRepository(`value`: Output<SourcePropertiesArgs>) {
        this.sourceRepository = value
    }

    /**
     * @param value The source event corresponding to the trigger.
     */
    @JvmName("wdoswlgfehkerehf")
    public suspend fun sourceTriggerEvents(`value`: Output<List<Either<String, SourceTriggerEvent>>>) {
        this.sourceTriggerEvents = value
    }

    @JvmName("qlrcwtafrtasjjrp")
    public suspend fun sourceTriggerEvents(vararg values: Output<Either<String, SourceTriggerEvent>>) {
        this.sourceTriggerEvents = Output.all(values.asList())
    }

    /**
     * @param values The source event corresponding to the trigger.
     */
    @JvmName("lnikprrnkjuohnlb")
    public suspend fun sourceTriggerEvents(values: List<Output<Either<String, SourceTriggerEvent>>>) {
        this.sourceTriggerEvents = Output.all(values)
    }

    /**
     * @param value The current status of trigger.
     */
    @JvmName("jngioryrlddubisg")
    public suspend fun status(`value`: Output<Either<String, TriggerStatus>>) {
        this.status = value
    }

    /**
     * @param value The name of the trigger.
     */
    @JvmName("hdfcfioorvepjckd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The properties that describes the source(code) for the task.
     */
    @JvmName("pywlnhchimjspfqt")
    public suspend fun sourceRepository(`value`: SourcePropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceRepository = mapped
    }

    /**
     * @param argument The properties that describes the source(code) for the task.
     */
    @JvmName("ovqkvvncpjlksvsv")
    public suspend fun sourceRepository(argument: suspend SourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceRepository = mapped
    }

    /**
     * @param value The source event corresponding to the trigger.
     */
    @JvmName("txqanebtqbginymi")
    public suspend fun sourceTriggerEvents(`value`: List<Either<String, SourceTriggerEvent>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceTriggerEvents = mapped
    }

    /**
     * @param values The source event corresponding to the trigger.
     */
    @JvmName("yyumrcxklodmcxnc")
    public suspend fun sourceTriggerEvents(vararg values: Either<String, SourceTriggerEvent>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceTriggerEvents = mapped
    }

    /**
     * @param value The current status of trigger.
     */
    @JvmName("vbifirblqtarfjkl")
    public suspend fun status(`value`: Either<String, TriggerStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The current status of trigger.
     */
    @JvmName("itadptqmyjlatwyn")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TriggerStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The current status of trigger.
     */
    @JvmName("sawngkuflyblxjyr")
    public fun status(`value`: TriggerStatus) {
        val toBeMapped = Either.ofRight<String, TriggerStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): SourceTriggerArgs = SourceTriggerArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        sourceRepository = sourceRepository ?: throw PulumiNullFieldException("sourceRepository"),
        sourceTriggerEvents = sourceTriggerEvents ?: throw PulumiNullFieldException("sourceTriggerEvents"),
        status = status,
    )
}
