@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.SyncPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The sync properties of the connected registry with its parent.
 * @property messageTtl The period of time for which a message is available to sync before it is expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
 * @property schedule The cron expression indicating the schedule that the connected registry will sync with its parent.
 * @property syncWindow The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
 * @property tokenId The resource ID of the ACR token used to authenticate the connected registry to its parent during sync.
 */
public data class SyncPropertiesArgs(
    public val messageTtl: Output<String>,
    public val schedule: Output<String>? = null,
    public val syncWindow: Output<String>? = null,
    public val tokenId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.SyncPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.SyncPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.SyncPropertiesArgs.builder()
            .messageTtl(messageTtl.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0 }))
            .syncWindow(syncWindow?.applyValue({ args0 -> args0 }))
            .tokenId(tokenId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyncPropertiesArgs].
 */
@PulumiTagMarker
public class SyncPropertiesArgsBuilder internal constructor() {
    private var messageTtl: Output<String>? = null

    private var schedule: Output<String>? = null

    private var syncWindow: Output<String>? = null

    private var tokenId: Output<String>? = null

    /**
     * @param value The period of time for which a message is available to sync before it is expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
     */
    @JvmName("ginaejgawguyugjv")
    public suspend fun messageTtl(`value`: Output<String>) {
        this.messageTtl = value
    }

    /**
     * @param value The cron expression indicating the schedule that the connected registry will sync with its parent.
     */
    @JvmName("ckagkbjxugeuuqxe")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
     */
    @JvmName("wnkacejsqveabevw")
    public suspend fun syncWindow(`value`: Output<String>) {
        this.syncWindow = value
    }

    /**
     * @param value The resource ID of the ACR token used to authenticate the connected registry to its parent during sync.
     */
    @JvmName("jkmyukvbwycmqyvt")
    public suspend fun tokenId(`value`: Output<String>) {
        this.tokenId = value
    }

    /**
     * @param value The period of time for which a message is available to sync before it is expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
     */
    @JvmName("nqbcbrpfhcguasrd")
    public suspend fun messageTtl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageTtl = mapped
    }

    /**
     * @param value The cron expression indicating the schedule that the connected registry will sync with its parent.
     */
    @JvmName("mfspwhbhgsqporwx")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
     */
    @JvmName("wbpgjayguviyufva")
    public suspend fun syncWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncWindow = mapped
    }

    /**
     * @param value The resource ID of the ACR token used to authenticate the connected registry to its parent during sync.
     */
    @JvmName("trubqwgijfjglyii")
    public suspend fun tokenId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenId = mapped
    }

    internal fun build(): SyncPropertiesArgs = SyncPropertiesArgs(
        messageTtl = messageTtl ?: throw PulumiNullFieldException("messageTtl"),
        schedule = schedule,
        syncWindow = syncWindow,
        tokenId = tokenId ?: throw PulumiNullFieldException("tokenId"),
    )
}
