@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.TokenCredentialsPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of the credentials that can be used for authenticating the token.
 * @property certificates
 * @property passwords
 */
public data class TokenCredentialsPropertiesArgs(
    public val certificates: Output<List<TokenCertificateArgs>>? = null,
    public val passwords: Output<List<TokenPasswordArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.TokenCredentialsPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.TokenCredentialsPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.TokenCredentialsPropertiesArgs.builder()
            .certificates(
                certificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .passwords(
                passwords?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TokenCredentialsPropertiesArgs].
 */
@PulumiTagMarker
public class TokenCredentialsPropertiesArgsBuilder internal constructor() {
    private var certificates: Output<List<TokenCertificateArgs>>? = null

    private var passwords: Output<List<TokenPasswordArgs>>? = null

    /**
     * @param value
     */
    @JvmName("fdvekxfcabeqfkxq")
    public suspend fun certificates(`value`: Output<List<TokenCertificateArgs>>) {
        this.certificates = value
    }

    @JvmName("wxftrnutaywwdpwa")
    public suspend fun certificates(vararg values: Output<TokenCertificateArgs>) {
        this.certificates = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("orlflockrplvxvvt")
    public suspend fun certificates(values: List<Output<TokenCertificateArgs>>) {
        this.certificates = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kssrxrjcohrdsgrn")
    public suspend fun passwords(`value`: Output<List<TokenPasswordArgs>>) {
        this.passwords = value
    }

    @JvmName("sesemxahpmqkbctv")
    public suspend fun passwords(vararg values: Output<TokenPasswordArgs>) {
        this.passwords = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("yiqlujuyqnxxtyto")
    public suspend fun passwords(values: List<Output<TokenPasswordArgs>>) {
        this.passwords = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("daqajyllakhjnuiq")
    public suspend fun certificates(`value`: List<TokenCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sbpbxvsfuafrgclu")
    public suspend fun certificates(argument: List<suspend TokenCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TokenCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vycqyplnhcjcprmu")
    public suspend fun certificates(vararg argument: suspend TokenCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TokenCertificateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rpunbcvvjobqnhgm")
    public suspend fun certificates(argument: suspend TokenCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TokenCertificateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.certificates = mapped
    }

    /**
     * @param values
     */
    @JvmName("ukdwcxxbakqluejn")
    public suspend fun certificates(vararg values: TokenCertificateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificates = mapped
    }

    /**
     * @param value
     */
    @JvmName("kijnfbouguygirma")
    public suspend fun passwords(`value`: List<TokenPasswordArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwords = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lqkqnlhnjkoiotky")
    public suspend fun passwords(argument: List<suspend TokenPasswordArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TokenPasswordArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.passwords = mapped
    }

    /**
     * @param argument
     */
    @JvmName("skmuwesfgyrpwwcj")
    public suspend fun passwords(vararg argument: suspend TokenPasswordArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TokenPasswordArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.passwords = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fkrtxtbjcrtvrmap")
    public suspend fun passwords(argument: suspend TokenPasswordArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TokenPasswordArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.passwords = mapped
    }

    /**
     * @param values
     */
    @JvmName("yckvmebsvdbdphys")
    public suspend fun passwords(vararg values: TokenPasswordArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.passwords = mapped
    }

    internal fun build(): TokenCredentialsPropertiesArgs = TokenCredentialsPropertiesArgs(
        certificates = certificates,
        passwords = passwords,
    )
}
