@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.TokenPasswordArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.TokenPasswordName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The password that will be used for authenticating the token of a container registry.
 * @property creationTime The creation datetime of the password.
 * @property expiry The expiry datetime of the password.
 * @property name The password name "password1" or "password2"
 */
public data class TokenPasswordArgs(
    public val creationTime: Output<String>? = null,
    public val expiry: Output<String>? = null,
    public val name: Output<Either<String, TokenPasswordName>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.TokenPasswordArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.TokenPasswordArgs =
        com.pulumi.azurenative.containerregistry.inputs.TokenPasswordArgs.builder()
            .creationTime(creationTime?.applyValue({ args0 -> args0 }))
            .expiry(expiry?.applyValue({ args0 -> args0 }))
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TokenPasswordArgs].
 */
@PulumiTagMarker
public class TokenPasswordArgsBuilder internal constructor() {
    private var creationTime: Output<String>? = null

    private var expiry: Output<String>? = null

    private var name: Output<Either<String, TokenPasswordName>>? = null

    /**
     * @param value The creation datetime of the password.
     */
    @JvmName("vornlypjrxwwcagy")
    public suspend fun creationTime(`value`: Output<String>) {
        this.creationTime = value
    }

    /**
     * @param value The expiry datetime of the password.
     */
    @JvmName("sucoqnsispvwbrqm")
    public suspend fun expiry(`value`: Output<String>) {
        this.expiry = value
    }

    /**
     * @param value The password name "password1" or "password2"
     */
    @JvmName("fbtwfngburbjjkmf")
    public suspend fun name(`value`: Output<Either<String, TokenPasswordName>>) {
        this.name = value
    }

    /**
     * @param value The creation datetime of the password.
     */
    @JvmName("oyqcueqggeqhdqes")
    public suspend fun creationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationTime = mapped
    }

    /**
     * @param value The expiry datetime of the password.
     */
    @JvmName("upkdgwjkksdlvcue")
    public suspend fun expiry(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiry = mapped
    }

    /**
     * @param value The password name "password1" or "password2"
     */
    @JvmName("rgfnkjhvpvcjhhrt")
    public suspend fun name(`value`: Either<String, TokenPasswordName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The password name "password1" or "password2"
     */
    @JvmName("tpltymjarcctjlah")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TokenPasswordName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The password name "password1" or "password2"
     */
    @JvmName("twegqrhbdoilebum")
    public fun name(`value`: TokenPasswordName) {
        val toBeMapped = Either.ofRight<String, TokenPasswordName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): TokenPasswordArgs = TokenPasswordArgs(
        creationTime = creationTime,
        expiry = expiry,
        name = name,
    )
}
