@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.TriggerPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of a trigger.
 * @property baseImageTrigger The trigger based on base image dependencies.
 * @property sourceTriggers The collection of triggers based on source code repository.
 * @property timerTriggers The collection of timer triggers.
 */
public data class TriggerPropertiesArgs(
    public val baseImageTrigger: Output<BaseImageTriggerArgs>? = null,
    public val sourceTriggers: Output<List<SourceTriggerArgs>>? = null,
    public val timerTriggers: Output<List<TimerTriggerArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.TriggerPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.TriggerPropertiesArgs =
        com.pulumi.azurenative.containerregistry.inputs.TriggerPropertiesArgs.builder()
            .baseImageTrigger(baseImageTrigger?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceTriggers(
                sourceTriggers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timerTriggers(
                timerTriggers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TriggerPropertiesArgs].
 */
@PulumiTagMarker
public class TriggerPropertiesArgsBuilder internal constructor() {
    private var baseImageTrigger: Output<BaseImageTriggerArgs>? = null

    private var sourceTriggers: Output<List<SourceTriggerArgs>>? = null

    private var timerTriggers: Output<List<TimerTriggerArgs>>? = null

    /**
     * @param value The trigger based on base image dependencies.
     */
    @JvmName("niykmbsrvhdunxfk")
    public suspend fun baseImageTrigger(`value`: Output<BaseImageTriggerArgs>) {
        this.baseImageTrigger = value
    }

    /**
     * @param value The collection of triggers based on source code repository.
     */
    @JvmName("ixettcaraunbyrfl")
    public suspend fun sourceTriggers(`value`: Output<List<SourceTriggerArgs>>) {
        this.sourceTriggers = value
    }

    @JvmName("snlareelcajbnxrh")
    public suspend fun sourceTriggers(vararg values: Output<SourceTriggerArgs>) {
        this.sourceTriggers = Output.all(values.asList())
    }

    /**
     * @param values The collection of triggers based on source code repository.
     */
    @JvmName("diujgkcxxhgdbgso")
    public suspend fun sourceTriggers(values: List<Output<SourceTriggerArgs>>) {
        this.sourceTriggers = Output.all(values)
    }

    /**
     * @param value The collection of timer triggers.
     */
    @JvmName("smdvtxsvgqwhkvhk")
    public suspend fun timerTriggers(`value`: Output<List<TimerTriggerArgs>>) {
        this.timerTriggers = value
    }

    @JvmName("jfuepuxfijgyyvhh")
    public suspend fun timerTriggers(vararg values: Output<TimerTriggerArgs>) {
        this.timerTriggers = Output.all(values.asList())
    }

    /**
     * @param values The collection of timer triggers.
     */
    @JvmName("myfjehvjenbhbcak")
    public suspend fun timerTriggers(values: List<Output<TimerTriggerArgs>>) {
        this.timerTriggers = Output.all(values)
    }

    /**
     * @param value The trigger based on base image dependencies.
     */
    @JvmName("oqwfcskygwankgmm")
    public suspend fun baseImageTrigger(`value`: BaseImageTriggerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseImageTrigger = mapped
    }

    /**
     * @param argument The trigger based on base image dependencies.
     */
    @JvmName("qkqbdtunwtittmak")
    public suspend fun baseImageTrigger(argument: suspend BaseImageTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = BaseImageTriggerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.baseImageTrigger = mapped
    }

    /**
     * @param value The collection of triggers based on source code repository.
     */
    @JvmName("hrkjdqteuhhoxywv")
    public suspend fun sourceTriggers(`value`: List<SourceTriggerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceTriggers = mapped
    }

    /**
     * @param argument The collection of triggers based on source code repository.
     */
    @JvmName("mqvtsqxdulxopooj")
    public suspend fun sourceTriggers(argument: List<suspend SourceTriggerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SourceTriggerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceTriggers = mapped
    }

    /**
     * @param argument The collection of triggers based on source code repository.
     */
    @JvmName("rnjeotoikhspacoi")
    public suspend fun sourceTriggers(vararg argument: suspend SourceTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SourceTriggerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceTriggers = mapped
    }

    /**
     * @param argument The collection of triggers based on source code repository.
     */
    @JvmName("vfwhxflcubsrltve")
    public suspend fun sourceTriggers(argument: suspend SourceTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SourceTriggerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sourceTriggers = mapped
    }

    /**
     * @param values The collection of triggers based on source code repository.
     */
    @JvmName("jkdknbjphynscdbf")
    public suspend fun sourceTriggers(vararg values: SourceTriggerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceTriggers = mapped
    }

    /**
     * @param value The collection of timer triggers.
     */
    @JvmName("ossrahramacgsbtf")
    public suspend fun timerTriggers(`value`: List<TimerTriggerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timerTriggers = mapped
    }

    /**
     * @param argument The collection of timer triggers.
     */
    @JvmName("kqpxhttwhycyusle")
    public suspend fun timerTriggers(argument: List<suspend TimerTriggerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TimerTriggerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.timerTriggers = mapped
    }

    /**
     * @param argument The collection of timer triggers.
     */
    @JvmName("xldymhermulyuvqw")
    public suspend fun timerTriggers(vararg argument: suspend TimerTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TimerTriggerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.timerTriggers = mapped
    }

    /**
     * @param argument The collection of timer triggers.
     */
    @JvmName("eplokmnpfenleuqd")
    public suspend fun timerTriggers(argument: suspend TimerTriggerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TimerTriggerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.timerTriggers = mapped
    }

    /**
     * @param values The collection of timer triggers.
     */
    @JvmName("uffwhycbwbtlfxqq")
    public suspend fun timerTriggers(vararg values: TimerTriggerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timerTriggers = mapped
    }

    internal fun build(): TriggerPropertiesArgs = TriggerPropertiesArgs(
        baseImageTrigger = baseImageTrigger,
        sourceTriggers = sourceTriggers,
        timerTriggers = timerTriggers,
    )
}
