@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The agent that initiated the event. For most situations, this could be from the authorization context of the request.
 * @property name The subject or username associated with the request context that generated the event.
 */
public data class ActorResponse(
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ActorResponse): ActorResponse = ActorResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
