@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of the archive package source.
 * @property type The type of package source for a archive.
 * @property url The external repository url.
 */
public data class ArchivePackageSourcePropertiesResponse(
    public val type: String? = null,
    public val url: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ArchivePackageSourcePropertiesResponse): ArchivePackageSourcePropertiesResponse = ArchivePackageSourcePropertiesResponse(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
