@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The properties of a run argument.
 * @property isSecret Flag to indicate whether the argument represents a secret and want to be removed from build logs.
 * @property name The name of the argument.
 * @property value The value of the argument.
 */
public data class ArgumentResponse(
    public val isSecret: Boolean? = null,
    public val name: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ArgumentResponse): ArgumentResponse = ArgumentResponse(
            isSecret = javaType.isSecret().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            `value` = javaType.`value`(),
        )
    }
}
