@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The authorization properties for accessing the source code repository.
 * @property expiresIn Time in seconds that the token remains valid
 * @property refreshToken The refresh token used to refresh the access token.
 * @property scope The scope of the access token.
 * @property token The access token used to access the source control provider.
 * @property tokenType The type of Auth token.
 */
public data class AuthInfoResponse(
    public val expiresIn: Int? = null,
    public val refreshToken: String? = null,
    public val scope: String? = null,
    public val token: String,
    public val tokenType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.AuthInfoResponse): AuthInfoResponse = AuthInfoResponse(
            expiresIn = javaType.expiresIn().map({ args0 -> args0 }).orElse(null),
            refreshToken = javaType.refreshToken().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            token = javaType.token(),
            tokenType = javaType.tokenType(),
        )
    }
}
