@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The trigger based on base image dependency.
 * @property baseImageTriggerType The type of the auto trigger for base image dependency updates.
 * @property name The name of the trigger.
 * @property status The current status of trigger.
 * @property updateTriggerEndpoint The endpoint URL for receiving update triggers.
 * @property updateTriggerPayloadType Type of Payload body for Base image update triggers.
 */
public data class BaseImageTriggerResponse(
    public val baseImageTriggerType: String,
    public val name: String,
    public val status: String? = null,
    public val updateTriggerEndpoint: String? = null,
    public val updateTriggerPayloadType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.BaseImageTriggerResponse): BaseImageTriggerResponse = BaseImageTriggerResponse(
            baseImageTriggerType = javaType.baseImageTriggerType(),
            name = javaType.name(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            updateTriggerEndpoint = javaType.updateTriggerEndpoint().map({ args0 -> args0 }).orElse(null),
            updateTriggerPayloadType = javaType.updateTriggerPayloadType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
