@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The health of the auth credential.
 * @property errorCode Error code representing the health check error.
 * @property errorMessage Descriptive message representing the health check error.
 * @property status The health status of credential.
 */
public data class CredentialHealthResponse(
    public val errorCode: String? = null,
    public val errorMessage: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.CredentialHealthResponse): CredentialHealthResponse = CredentialHealthResponse(
            errorCode = javaType.errorCode().map({ args0 -> args0 }).orElse(null),
            errorMessage = javaType.errorMessage().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
