@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The parameters that describes a set of credentials that will be used when a run is invoked.
 * @property customRegistries Describes the credential parameters for accessing other custom registries. The key
 * for the dictionary item will be the registry login server (myregistry.azurecr.io) and
 * the value of the item will be the registry credentials for accessing the registry.
 * @property sourceRegistry Describes the credential parameters for accessing the source registry.
 */
public data class CredentialsResponse(
    public val customRegistries: Map<String, CustomRegistryCredentialsResponse>? = null,
    public val sourceRegistry: SourceRegistryCredentialsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.CredentialsResponse): CredentialsResponse = CredentialsResponse(
            customRegistries = javaType.customRegistries().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.containerregistry.kotlin.outputs.CustomRegistryCredentialsResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            sourceRegistry = javaType.sourceRegistry().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.SourceRegistryCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
