@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The parameters for a docker quick build.
 * @property agentConfiguration The machine configuration of the run agent.
 * @property agentPoolName The dedicated agent pool for the run.
 * @property arguments The collection of override arguments to be used when executing the run.
 * @property credentials The properties that describes a set of credentials that will be used when this run is invoked.
 * @property dockerFilePath The Docker file path relative to the source location.
 * @property imageNames The fully qualified image names including the repository and tag.
 * @property isArchiveEnabled The value that indicates whether archiving is enabled for the run or not.
 * @property isPushEnabled The value of this property indicates whether the image built should be pushed to the registry or not.
 * @property logTemplate The template that describes the repository and tag information for run log artifact.
 * @property noCache The value of this property indicates whether the image cache is enabled or not.
 * @property platform The platform properties against which the run has to happen.
 * @property sourceLocation The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
 * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
 * @property target The name of the target build stage for the docker build.
 * @property timeout Run timeout in seconds.
 * @property type The type of the run request.
 * Expected value is 'DockerBuildRequest'.
 */
public data class DockerBuildRequestResponse(
    public val agentConfiguration: AgentPropertiesResponse? = null,
    public val agentPoolName: String? = null,
    public val arguments: List<ArgumentResponse>? = null,
    public val credentials: CredentialsResponse? = null,
    public val dockerFilePath: String,
    public val imageNames: List<String>? = null,
    public val isArchiveEnabled: Boolean? = null,
    public val isPushEnabled: Boolean? = null,
    public val logTemplate: String? = null,
    public val noCache: Boolean? = null,
    public val platform: PlatformPropertiesResponse,
    public val sourceLocation: String? = null,
    public val target: String? = null,
    public val timeout: Int? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.DockerBuildRequestResponse): DockerBuildRequestResponse = DockerBuildRequestResponse(
            agentConfiguration = javaType.agentConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.AgentPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            agentPoolName = javaType.agentPoolName().map({ args0 -> args0 }).orElse(null),
            arguments = javaType.arguments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.ArgumentResponse.Companion.toKotlin(args0)
                })
            }),
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.CredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dockerFilePath = javaType.dockerFilePath(),
            imageNames = javaType.imageNames().map({ args0 -> args0 }),
            isArchiveEnabled = javaType.isArchiveEnabled().map({ args0 -> args0 }).orElse(null),
            isPushEnabled = javaType.isPushEnabled().map({ args0 -> args0 }).orElse(null),
            logTemplate = javaType.logTemplate().map({ args0 -> args0 }).orElse(null),
            noCache = javaType.noCache().map({ args0 -> args0 }).orElse(null),
            platform = javaType.platform().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.PlatformPropertiesResponse.Companion.toKotlin(args0)
            }),
            sourceLocation = javaType.sourceLocation().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
