@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property keyVaultProperties Key vault properties.
 * @property status Indicates whether or not the encryption is enabled for container registry.
 */
public data class EncryptionPropertyResponse(
    public val keyVaultProperties: KeyVaultPropertiesResponse? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.EncryptionPropertyResponse): EncryptionPropertyResponse = EncryptionPropertyResponse(
            keyVaultProperties = javaType.keyVaultProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
