@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The event request message sent to the service URI.
 * @property content The content of the event request message.
 * @property headers The headers of the event request message.
 * @property method The HTTP method used to send the event request message.
 * @property requestUri The URI used to send the event request message.
 * @property version The HTTP message version.
 */
public data class EventRequestMessageResponse(
    public val content: EventContentResponse? = null,
    public val headers: Map<String, String>? = null,
    public val method: String? = null,
    public val requestUri: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.EventRequestMessageResponse): EventRequestMessageResponse = EventRequestMessageResponse(
            content = javaType.content().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.EventContentResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            headers = javaType.headers().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            method = javaType.method().map({ args0 -> args0 }).orElse(null),
            requestUri = javaType.requestUri().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
