@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of the export pipeline target.
 * @property keyVaultUri They key vault secret uri to obtain the target storage SAS token.
 * @property type The type of target for the export pipeline.
 * @property uri The target uri of the export pipeline.
 * When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
 * When 'AzureStorageBlobContainer':  "https://accountName.blob.core.windows.net/containerName"
 */
public data class ExportPipelineTargetPropertiesResponse(
    public val keyVaultUri: String,
    public val type: String? = null,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ExportPipelineTargetPropertiesResponse): ExportPipelineTargetPropertiesResponse = ExportPipelineTargetPropertiesResponse(
            keyVaultUri = javaType.keyVaultUri(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
