@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The request parameters for a scheduling run against a task file.
 * @property agentConfiguration The machine configuration of the run agent.
 * @property agentPoolName The dedicated agent pool for the run.
 * @property credentials The properties that describes a set of credentials that will be used when this run is invoked.
 * @property isArchiveEnabled The value that indicates whether archiving is enabled for the run or not.
 * @property logTemplate The template that describes the repository and tag information for run log artifact.
 * @property platform The platform properties against which the run has to happen.
 * @property sourceLocation The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
 * If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
 * @property taskFilePath The template/definition file path relative to the source.
 * @property timeout Run timeout in seconds.
 * @property type The type of the run request.
 * Expected value is 'FileTaskRunRequest'.
 * @property values The collection of overridable values that can be passed when running a task.
 * @property valuesFilePath The values/parameters file path relative to the source.
 */
public data class FileTaskRunRequestResponse(
    public val agentConfiguration: AgentPropertiesResponse? = null,
    public val agentPoolName: String? = null,
    public val credentials: CredentialsResponse? = null,
    public val isArchiveEnabled: Boolean? = null,
    public val logTemplate: String? = null,
    public val platform: PlatformPropertiesResponse,
    public val sourceLocation: String? = null,
    public val taskFilePath: String,
    public val timeout: Int? = null,
    public val type: String,
    public val values: List<SetValueResponse>? = null,
    public val valuesFilePath: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.FileTaskRunRequestResponse): FileTaskRunRequestResponse = FileTaskRunRequestResponse(
            agentConfiguration = javaType.agentConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.AgentPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            agentPoolName = javaType.agentPoolName().map({ args0 -> args0 }).orElse(null),
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.CredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isArchiveEnabled = javaType.isArchiveEnabled().map({ args0 -> args0 }).orElse(null),
            logTemplate = javaType.logTemplate().map({ args0 -> args0 }).orElse(null),
            platform = javaType.platform().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.PlatformPropertiesResponse.Companion.toKotlin(args0)
            }),
            sourceLocation = javaType.sourceLocation().map({ args0 -> args0 }).orElse(null),
            taskFilePath = javaType.taskFilePath(),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            values = javaType.values().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.SetValueResponse.Companion.toKotlin(args0)
                })
            }),
            valuesFilePath = javaType.valuesFilePath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
