@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The agentpool that has the ARM resource and properties.
 * The agentpool will have all information to create an agent pool.
 * @property count The count of agent machine
 * @property id The resource ID.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property name The name of the resource.
 * @property os The OS of agent machine
 * @property provisioningState The provisioning state of this agent pool
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags The tags of the resource.
 * @property tier The Tier of agent machine
 * @property type The type of the resource.
 * @property virtualNetworkSubnetResourceId The Virtual Network Subnet Resource Id of the agent machine
 */
public data class GetAgentPoolResult(
    public val count: Int? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val os: String? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tier: String? = null,
    public val type: String,
    public val virtualNetworkSubnetResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetAgentPoolResult): GetAgentPoolResult = GetAgentPoolResult(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            os = javaType.os().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            virtualNetworkSubnetResourceId = javaType.virtualNetworkSubnetResourceId().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
