@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An object that represents a archive for a container registry.
 * @property id The resource ID.
 * @property name The name of the resource.
 * @property packageSource The package source of the archive.
 * @property provisioningState The provisioning state of the archive at the time the operation was called.
 * @property publishedVersion The published version of the archive.
 * @property repositoryEndpoint
 * @property repositoryEndpointPrefix
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 */
public data class GetArchifeResult(
    public val id: String,
    public val name: String,
    public val packageSource: ArchivePackageSourcePropertiesResponse? = null,
    public val provisioningState: String,
    public val publishedVersion: String? = null,
    public val repositoryEndpoint: String,
    public val repositoryEndpointPrefix: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetArchifeResult): GetArchifeResult = GetArchifeResult(
            id = javaType.id(),
            name = javaType.name(),
            packageSource = javaType.packageSource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.ArchivePackageSourcePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publishedVersion = javaType.publishedVersion().map({ args0 -> args0 }).orElse(null),
            repositoryEndpoint = javaType.repositoryEndpoint(),
            repositoryEndpointPrefix = javaType.repositoryEndpointPrefix().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
