@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An object that represents a credential set resource for a container registry.
 * @property authCredentials List of authentication credentials stored for an upstream.
 * Usually consists of a primary and an optional secondary credential.
 * @property creationDate The creation date of credential store resource.
 * @property id The resource ID.
 * @property identity Identities associated with the resource. This is used to access the KeyVault secrets.
 * @property loginServer The credentials are stored for this upstream or login server.
 * @property name The name of the resource.
 * @property provisioningState Provisioning state of the resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 */
public data class GetCredentialSetResult(
    public val authCredentials: List<AuthCredentialResponse>? = null,
    public val creationDate: String,
    public val id: String,
    public val identity: IdentityPropertiesResponse? = null,
    public val loginServer: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetCredentialSetResult): GetCredentialSetResult = GetCredentialSetResult(
            authCredentials = javaType.authCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.AuthCredentialResponse.Companion.toKotlin(args0)
                })
            }),
            creationDate = javaType.creationDate(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            loginServer = javaType.loginServer().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
