@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An object that represents an export pipeline for a container registry.
 * @property id The resource ID.
 * @property identity The identity of the export pipeline.
 * @property location The location of the export pipeline.
 * @property name The name of the resource.
 * @property options The list of all options configured for the pipeline.
 * @property provisioningState The provisioning state of the pipeline at the time the operation was called.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property target The target properties of the export pipeline.
 * @property type The type of the resource.
 */
public data class GetExportPipelineResult(
    public val id: String,
    public val identity: IdentityPropertiesResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val options: List<String>? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val target: ExportPipelineTargetPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetExportPipelineResult): GetExportPipelineResult = GetExportPipelineResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            options = javaType.options().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            target = javaType.target().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.ExportPipelineTargetPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
