@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An object that represents a container registry.
 * @property adminUserEnabled The value that indicates whether the admin user is enabled.
 * @property creationDate The creation date of the container registry in ISO8601 format.
 * @property dataEndpointEnabled Enable a single data endpoint per region for serving data.
 * @property dataEndpointHostNames List of host names that will serve data when dataEndpointEnabled is true.
 * @property encryption The encryption settings of container registry.
 * @property id The resource ID.
 * @property identity The identity of the container registry.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property loginServer The URL that can be used to log into the container registry.
 * @property name The name of the resource.
 * @property networkRuleBypassOptions Whether to allow trusted Azure services to access a network restricted registry.
 * @property networkRuleSet The network rule set for a container registry.
 * @property policies The policies for a container registry.
 * @property privateEndpointConnections List of private endpoint connections for a container registry.
 * @property provisioningState The provisioning state of the container registry at the time the operation was called.
 * @property publicNetworkAccess Whether or not public network access is allowed for the container registry.
 * @property sku The SKU of the container registry.
 * @property status The status of the container registry at the time the operation was called.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property zoneRedundancy Whether or not zone redundancy is enabled for this container registry
 */
public data class GetRegistryResult(
    public val adminUserEnabled: Boolean? = null,
    public val creationDate: String,
    public val dataEndpointEnabled: Boolean? = null,
    public val dataEndpointHostNames: List<String>,
    public val encryption: EncryptionPropertyResponse? = null,
    public val id: String,
    public val identity: IdentityPropertiesResponse? = null,
    public val location: String,
    public val loginServer: String,
    public val name: String,
    public val networkRuleBypassOptions: String? = null,
    public val networkRuleSet: NetworkRuleSetResponse? = null,
    public val policies: PoliciesResponse? = null,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val sku: SkuResponse,
    public val status: StatusResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zoneRedundancy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetRegistryResult): GetRegistryResult = GetRegistryResult(
            adminUserEnabled = javaType.adminUserEnabled().map({ args0 -> args0 }).orElse(null),
            creationDate = javaType.creationDate(),
            dataEndpointEnabled = javaType.dataEndpointEnabled().map({ args0 -> args0 }).orElse(null),
            dataEndpointHostNames = javaType.dataEndpointHostNames().map({ args0 -> args0 }),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.EncryptionPropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            loginServer = javaType.loginServer(),
            name = javaType.name(),
            networkRuleBypassOptions = javaType.networkRuleBypassOptions().map({ args0 -> args0 }).orElse(null),
            networkRuleSet = javaType.networkRuleSet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.NetworkRuleSetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.PoliciesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.StatusResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zoneRedundancy = javaType.zoneRedundancy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
