@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An object that represents a replication for a container registry.
 * @property id The resource ID.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property name The name of the resource.
 * @property provisioningState The provisioning state of the replication at the time the operation was called.
 * @property regionEndpointEnabled Specifies whether the replication's regional endpoint is enabled. Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue to be synced with other replications.
 * @property status The status of the replication at the time the operation was called.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property zoneRedundancy Whether or not zone redundancy is enabled for this container registry replication
 */
public data class GetReplicationResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val regionEndpointEnabled: Boolean? = null,
    public val status: StatusResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zoneRedundancy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetReplicationResult): GetReplicationResult = GetReplicationResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            regionEndpointEnabled = javaType.regionEndpointEnabled().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.StatusResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zoneRedundancy = javaType.zoneRedundancy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
