@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An object that represents a token for a container registry.
 * @property creationDate The creation date of scope map.
 * @property credentials The credentials that can be used for authenticating the token.
 * @property id The resource ID.
 * @property name The name of the resource.
 * @property provisioningState Provisioning state of the resource.
 * @property scopeMapId The resource ID of the scope map to which the token will be associated with.
 * @property status The status of the token example enabled or disabled.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 */
public data class GetTokenResult(
    public val creationDate: String,
    public val credentials: TokenCredentialsPropertiesResponse? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val scopeMapId: String? = null,
    public val status: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.GetTokenResult): GetTokenResult = GetTokenResult(
            creationDate = javaType.creationDate(),
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.TokenCredentialsPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            scopeMapId = javaType.scopeMapId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
