@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property identity The client id of the identity which will be used to access key vault.
 * @property keyIdentifier Key vault uri to access the encryption key.
 * @property keyRotationEnabled Auto key rotation status for a CMK enabled registry.
 * @property lastKeyRotationTimestamp Timestamp of the last successful key rotation.
 * @property versionedKeyIdentifier The fully qualified key identifier that includes the version of the key that is actually used for encryption.
 */
public data class KeyVaultPropertiesResponse(
    public val identity: String? = null,
    public val keyIdentifier: String? = null,
    public val keyRotationEnabled: Boolean,
    public val lastKeyRotationTimestamp: String,
    public val versionedKeyIdentifier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.KeyVaultPropertiesResponse): KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            identity = javaType.identity().map({ args0 -> args0 }).orElse(null),
            keyIdentifier = javaType.keyIdentifier().map({ args0 -> args0 }).orElse(null),
            keyRotationEnabled = javaType.keyRotationEnabled(),
            lastKeyRotationTimestamp = javaType.lastKeyRotationTimestamp(),
            versionedKeyIdentifier = javaType.versionedKeyIdentifier(),
        )
    }
}
