@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of a response to source upload request.
 * @property relativePath The relative path to the source. This is used to submit the subsequent queue build request.
 * @property uploadUrl The URL where the client can upload the source.
 */
public data class ListRegistryBuildSourceUploadUrlResult(
    public val relativePath: String? = null,
    public val uploadUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ListRegistryBuildSourceUploadUrlResult): ListRegistryBuildSourceUploadUrlResult = ListRegistryBuildSourceUploadUrlResult(
            relativePath = javaType.relativePath().map({ args0 -> args0 }).orElse(null),
            uploadUrl = javaType.uploadUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
