@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The result of get log link operation.
 * @property logArtifactLink The link to logs in registry for a run on a azure container registry.
 * @property logLink The link to logs for a run on a azure container registry.
 */
public data class ListRunLogSasUrlResult(
    public val logArtifactLink: String? = null,
    public val logLink: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ListRunLogSasUrlResult): ListRunLogSasUrlResult = ListRunLogSasUrlResult(
            logArtifactLink = javaType.logArtifactLink().map({ args0 -> args0 }).orElse(null),
            logLink = javaType.logLink().map({ args0 -> args0 }).orElse(null),
        )
    }
}
