@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The task that has the ARM resource and task properties.
 * The task will have all information to schedule a run against it.
 * @property agentConfiguration The machine configuration of the run agent.
 * @property agentPoolName The dedicated agent pool for the task.
 * @property creationDate The creation date of task.
 * @property credentials The properties that describes a set of credentials that will be used when this run is invoked.
 * @property id The resource ID.
 * @property identity Identity for the resource.
 * @property isSystemTask The value of this property indicates whether the task resource is system task or not.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property logTemplate The template that describes the repository and tag information for run log artifact.
 * @property name The name of the resource.
 * @property platform The platform properties against which the run has to happen.
 * @property provisioningState The provisioning state of the task.
 * @property status The current status of task.
 * @property step The properties of a task step.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags The tags of the resource.
 * @property timeout Run timeout in seconds.
 * @property trigger The properties that describe all triggers for the task.
 * @property type The type of the resource.
 */
public data class ListTaskDetailsResult(
    public val agentConfiguration: AgentPropertiesResponse? = null,
    public val agentPoolName: String? = null,
    public val creationDate: String,
    public val credentials: CredentialsResponse? = null,
    public val id: String,
    public val identity: IdentityPropertiesResponse? = null,
    public val isSystemTask: Boolean? = null,
    public val location: String,
    public val logTemplate: String? = null,
    public val name: String,
    public val platform: PlatformPropertiesResponse? = null,
    public val provisioningState: String,
    public val status: String? = null,
    public val step: Any? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val timeout: Int? = null,
    public val trigger: TriggerPropertiesResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ListTaskDetailsResult): ListTaskDetailsResult = ListTaskDetailsResult(
            agentConfiguration = javaType.agentConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.AgentPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            agentPoolName = javaType.agentPoolName().map({ args0 -> args0 }).orElse(null),
            creationDate = javaType.creationDate(),
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.CredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isSystemTask = javaType.isSystemTask().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            logTemplate = javaType.logTemplate().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            platform = javaType.platform().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.PlatformPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            step = javaType.step().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            trigger = javaType.trigger().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.TriggerPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
