@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The task run that has the ARM resource and properties.
 * The task run will have the information of request and result of a run.
 * @property forceUpdateTag How the run should be forced to rerun even if the run request configuration has not changed
 * @property id The resource ID.
 * @property identity Identity for the resource.
 * @property location The location of the resource
 * @property name The name of the resource.
 * @property provisioningState The provisioning state of this task run
 * @property runRequest The request (parameters) for the run
 * @property runResult The result of this task run
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 */
public data class ListTaskRunDetailsResult(
    public val forceUpdateTag: String? = null,
    public val id: String,
    public val identity: IdentityPropertiesResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val runRequest: Any? = null,
    public val runResult: RunResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.ListTaskRunDetailsResult): ListTaskRunDetailsResult = ListTaskRunDetailsResult(
            forceUpdateTag = javaType.forceUpdateTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.IdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            runRequest = javaType.runRequest().map({ args0 -> args0 }).orElse(null),
            runResult = javaType.runResult().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.RunResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
