@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The logging properties of the connected registry.
 * @property auditLogStatus Indicates whether audit logs are enabled on the connected registry.
 * @property logLevel The verbosity of logs persisted on the connected registry.
 */
public data class LoggingPropertiesResponse(
    public val auditLogStatus: String? = null,
    public val logLevel: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.LoggingPropertiesResponse): LoggingPropertiesResponse = LoggingPropertiesResponse(
            auditLogStatus = javaType.auditLogStatus().map({ args0 -> args0 }).orElse(null),
            logLevel = javaType.logLevel().map({ args0 -> args0 }).orElse(null),
        )
    }
}
