@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property arguments Gets or sets the collection of override arguments to be used when
 * executing a build step.
 * @property contextPath The source context against which run has to be queued.
 * @property file The file against which run has to be queued.
 * @property target The name of the target build stage for the docker build.
 * @property updateTriggerToken Base64 encoded update trigger token that will be attached with the base image trigger webhook.
 * @property values The collection of overridable values that can be passed when running a Task.
 */
public data class OverrideTaskStepPropertiesResponse(
    public val arguments: List<ArgumentResponse>? = null,
    public val contextPath: String? = null,
    public val `file`: String? = null,
    public val target: String? = null,
    public val updateTriggerToken: String? = null,
    public val values: List<SetValueResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.OverrideTaskStepPropertiesResponse): OverrideTaskStepPropertiesResponse = OverrideTaskStepPropertiesResponse(
            arguments = javaType.arguments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.ArgumentResponse.Companion.toKotlin(args0)
                })
            }),
            contextPath = javaType.contextPath().map({ args0 -> args0 }).orElse(null),
            `file` = javaType.`file`().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
            updateTriggerToken = javaType.updateTriggerToken().map({ args0 -> args0 }).orElse(null),
            values = javaType.values().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.SetValueResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
