@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The request properties provided for a pipeline run.
 * @property artifacts List of source artifacts to be transferred by the pipeline.
 * Specify an image by repository ('hello-world'). This will use the 'latest' tag.
 * Specify an image by tag ('hello-world:latest').
 * Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
 * @property catalogDigest The digest of the tar used to transfer the artifacts.
 * @property pipelineResourceId The resource ID of the pipeline to run.
 * @property source The source properties of the pipeline run.
 * @property target The target properties of the pipeline run.
 */
public data class PipelineRunRequestResponse(
    public val artifacts: List<String>? = null,
    public val catalogDigest: String? = null,
    public val pipelineResourceId: String? = null,
    public val source: PipelineRunSourcePropertiesResponse? = null,
    public val target: PipelineRunTargetPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.PipelineRunRequestResponse): PipelineRunRequestResponse = PipelineRunRequestResponse(
            artifacts = javaType.artifacts().map({ args0 -> args0 }),
            catalogDigest = javaType.catalogDigest().map({ args0 -> args0 }).orElse(null),
            pipelineResourceId = javaType.pipelineResourceId().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.PipelineRunSourcePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            target = javaType.target().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.PipelineRunTargetPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
