@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The response properties returned for a pipeline run.
 * @property catalogDigest The digest of the tar used to transfer the artifacts.
 * @property finishTime The time the pipeline run finished.
 * @property importedArtifacts The artifacts imported in the pipeline run.
 * @property pipelineRunErrorMessage The detailed error message for the pipeline run in the case of failure.
 * @property progress The current progress of the copy operation.
 * @property source The source of the pipeline run.
 * @property startTime The time the pipeline run started.
 * @property status The current status of the pipeline run.
 * @property target The target of the pipeline run.
 * @property trigger The trigger that caused the pipeline run.
 */
public data class PipelineRunResponseResponse(
    public val catalogDigest: String? = null,
    public val finishTime: String? = null,
    public val importedArtifacts: List<String>? = null,
    public val pipelineRunErrorMessage: String? = null,
    public val progress: ProgressPropertiesResponse? = null,
    public val source: ImportPipelineSourcePropertiesResponse? = null,
    public val startTime: String? = null,
    public val status: String? = null,
    public val target: ExportPipelineTargetPropertiesResponse? = null,
    public val trigger: PipelineTriggerDescriptorResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.PipelineRunResponseResponse): PipelineRunResponseResponse = PipelineRunResponseResponse(
            catalogDigest = javaType.catalogDigest().map({ args0 -> args0 }).orElse(null),
            finishTime = javaType.finishTime().map({ args0 -> args0 }).orElse(null),
            importedArtifacts = javaType.importedArtifacts().map({ args0 -> args0 }),
            pipelineRunErrorMessage = javaType.pipelineRunErrorMessage().map({ args0 -> args0 }).orElse(null),
            progress = javaType.progress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.ProgressPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            source = javaType.source().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.ImportPipelineSourcePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.ExportPipelineTargetPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            trigger = javaType.trigger().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.PipelineTriggerDescriptorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
