@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The platform properties against which the run has to happen.
 * @property architecture The OS architecture.
 * @property os The operating system type required for the run.
 * @property variant Variant of the CPU.
 */
public data class PlatformPropertiesResponse(
    public val architecture: String? = null,
    public val os: String,
    public val variant: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.PlatformPropertiesResponse): PlatformPropertiesResponse = PlatformPropertiesResponse(
            architecture = javaType.architecture().map({ args0 -> args0 }).orElse(null),
            os = javaType.os(),
            variant = javaType.variant().map({ args0 -> args0 }).orElse(null),
        )
    }
}
