@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The state of a private link service connection.
 * @property actionsRequired A message indicating if changes on the service provider require any updates on the consumer.
 * @property description The description for connection status. For example if connection is rejected it can indicate reason for rejection.
 * @property status The private link service connection status.
 */
public data class PrivateLinkServiceConnectionStateResponse(
    public val actionsRequired: String? = null,
    public val description: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.PrivateLinkServiceConnectionStateResponse): PrivateLinkServiceConnectionStateResponse = PrivateLinkServiceConnectionStateResponse(
            actionsRequired = javaType.actionsRequired().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
