@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The request that generated the event.
 * @property addr The IP or hostname and possibly port of the client connection that initiated the event. This is the RemoteAddr from the standard http request.
 * @property host The externally accessible hostname of the registry instance, as specified by the http host header on incoming requests.
 * @property id The ID of the request that initiated the event.
 * @property method The request method that generated the event.
 * @property useragent The user agent header of the request.
 */
public data class RequestResponse(
    public val addr: String? = null,
    public val host: String? = null,
    public val id: String? = null,
    public val method: String? = null,
    public val useragent: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.RequestResponse): RequestResponse = RequestResponse(
            addr = javaType.addr().map({ args0 -> args0 }).orElse(null),
            host = javaType.host().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            method = javaType.method().map({ args0 -> args0 }).orElse(null),
            useragent = javaType.useragent().map({ args0 -> args0 }).orElse(null),
        )
    }
}
