@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The retention policy for a container registry.
 * @property days The number of days to retain an untagged manifest after which it gets purged.
 * @property lastUpdatedTime The timestamp when the policy was last updated.
 * @property status The value that indicates whether the policy is enabled or not.
 */
public data class RetentionPolicyResponse(
    public val days: Int? = null,
    public val lastUpdatedTime: String,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.RetentionPolicyResponse): RetentionPolicyResponse = RetentionPolicyResponse(
            days = javaType.days().map({ args0 -> args0 }).orElse(null),
            lastUpdatedTime = javaType.lastUpdatedTime(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
