@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the properties of a secret object value.
 * @property type The type of the secret object which determines how the value of the secret object has to be
 * interpreted.
 * @property value The value of the secret. The format of this value will be determined
 * based on the type of the secret object. If the type is Opaque, the value will be
 * used as is without any modification.
 */
public data class SecretObjectResponse(
    public val type: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.SecretObjectResponse): SecretObjectResponse = SecretObjectResponse(
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
