@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
 * @property addr The IP or hostname and the port of the registry node that generated the event. Generally, this will be resolved by os.Hostname() along with the running port.
 * @property instanceID The running instance of an application. Changes after each restart.
 */
public data class SourceResponse(
    public val addr: String? = null,
    public val instanceID: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.SourceResponse): SourceResponse = SourceResponse(
            addr = javaType.addr().map({ args0 -> args0 }).orElse(null),
            instanceID = javaType.instanceID().map({ args0 -> args0 }).orElse(null),
        )
    }
}
