@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The status detail properties of the connected registry.
 * @property code The code of the status.
 * @property correlationId The correlation ID of the status.
 * @property description The description of the status.
 * @property timestamp The timestamp of the status.
 * @property type The component of the connected registry corresponding to the status.
 */
public data class StatusDetailPropertiesResponse(
    public val code: String,
    public val correlationId: String,
    public val description: String,
    public val timestamp: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.StatusDetailPropertiesResponse): StatusDetailPropertiesResponse = StatusDetailPropertiesResponse(
            code = javaType.code(),
            correlationId = javaType.correlationId(),
            description = javaType.description(),
            timestamp = javaType.timestamp(),
            type = javaType.type(),
        )
    }
}
