@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The sync properties of the connected registry with its parent.
 * @property gatewayEndpoint The gateway endpoint used by the connected registry to communicate with its parent.
 * @property lastSyncTime The last time a sync occurred between the connected registry and its parent.
 * @property messageTtl The period of time for which a message is available to sync before it is expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
 * @property schedule The cron expression indicating the schedule that the connected registry will sync with its parent.
 * @property syncWindow The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
 * @property tokenId The resource ID of the ACR token used to authenticate the connected registry to its parent during sync.
 */
public data class SyncPropertiesResponse(
    public val gatewayEndpoint: String,
    public val lastSyncTime: String,
    public val messageTtl: String,
    public val schedule: String? = null,
    public val syncWindow: String? = null,
    public val tokenId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.SyncPropertiesResponse): SyncPropertiesResponse = SyncPropertiesResponse(
            gatewayEndpoint = javaType.gatewayEndpoint(),
            lastSyncTime = javaType.lastSyncTime(),
            messageTtl = javaType.messageTtl(),
            schedule = javaType.schedule().map({ args0 -> args0 }).orElse(null),
            syncWindow = javaType.syncWindow().map({ args0 -> args0 }).orElse(null),
            tokenId = javaType.tokenId(),
        )
    }
}
