@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The parameters for a task run request.
 * @property agentPoolName The dedicated agent pool for the run.
 * @property isArchiveEnabled The value that indicates whether archiving is enabled for the run or not.
 * @property logTemplate The template that describes the repository and tag information for run log artifact.
 * @property overrideTaskStepProperties Set of overridable parameters that can be passed when running a Task.
 * @property taskId The resource ID of task against which run has to be queued.
 * @property type The type of the run request.
 * Expected value is 'TaskRunRequest'.
 */
public data class TaskRunRequestResponse(
    public val agentPoolName: String? = null,
    public val isArchiveEnabled: Boolean? = null,
    public val logTemplate: String? = null,
    public val overrideTaskStepProperties: OverrideTaskStepPropertiesResponse? = null,
    public val taskId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.TaskRunRequestResponse): TaskRunRequestResponse = TaskRunRequestResponse(
            agentPoolName = javaType.agentPoolName().map({ args0 -> args0 }).orElse(null),
            isArchiveEnabled = javaType.isArchiveEnabled().map({ args0 -> args0 }).orElse(null),
            logTemplate = javaType.logTemplate().map({ args0 -> args0 }).orElse(null),
            overrideTaskStepProperties = javaType.overrideTaskStepProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.OverrideTaskStepPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            taskId = javaType.taskId(),
            type = javaType.type(),
        )
    }
}
