@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of a certificate used for authenticating a token.
 * @property encodedPemCertificate Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
 * @property expiry The expiry datetime of the certificate.
 * @property name
 * @property thumbprint The thumbprint of the certificate.
 */
public data class TokenCertificateResponse(
    public val encodedPemCertificate: String? = null,
    public val expiry: String? = null,
    public val name: String? = null,
    public val thumbprint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.TokenCertificateResponse): TokenCertificateResponse = TokenCertificateResponse(
            encodedPemCertificate = javaType.encodedPemCertificate().map({ args0 -> args0 }).orElse(null),
            expiry = javaType.expiry().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            thumbprint = javaType.thumbprint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
