@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of the credentials that can be used for authenticating the token.
 * @property certificates
 * @property passwords
 */
public data class TokenCredentialsPropertiesResponse(
    public val certificates: List<TokenCertificateResponse>? = null,
    public val passwords: List<TokenPasswordResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.TokenCredentialsPropertiesResponse): TokenCredentialsPropertiesResponse = TokenCredentialsPropertiesResponse(
            certificates = javaType.certificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.TokenCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            passwords = javaType.passwords().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.TokenPasswordResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
