@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of a trigger.
 * @property baseImageTrigger The trigger based on base image dependencies.
 * @property sourceTriggers The collection of triggers based on source code repository.
 * @property timerTriggers The collection of timer triggers.
 */
public data class TriggerPropertiesResponse(
    public val baseImageTrigger: BaseImageTriggerResponse? = null,
    public val sourceTriggers: List<SourceTriggerResponse>? = null,
    public val timerTriggers: List<TimerTriggerResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.outputs.TriggerPropertiesResponse): TriggerPropertiesResponse = TriggerPropertiesResponse(
            baseImageTrigger = javaType.baseImageTrigger().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.BaseImageTriggerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceTriggers = javaType.sourceTriggers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.SourceTriggerResponse.Companion.toKotlin(args0)
                })
            }),
            timerTriggers = javaType.timerTriggers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerregistry.kotlin.outputs.TimerTriggerResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
