@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerservice.kotlin

import com.pulumi.azurenative.containerservice.kotlin.outputs.AgentPoolUpgradeSettingsResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.CreationDataResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.KubeletConfigResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.LinuxOSConfigResponse
import com.pulumi.azurenative.containerservice.kotlin.outputs.PowerStateResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.containerservice.kotlin.outputs.AgentPoolUpgradeSettingsResponse.Companion.toKotlin as agentPoolUpgradeSettingsResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.CreationDataResponse.Companion.toKotlin as creationDataResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.KubeletConfigResponse.Companion.toKotlin as kubeletConfigResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.LinuxOSConfigResponse.Companion.toKotlin as linuxOSConfigResponseToKotlin
import com.pulumi.azurenative.containerservice.kotlin.outputs.PowerStateResponse.Companion.toKotlin as powerStateResponseToKotlin

/**
 * Builder for [AgentPool].
 */
@PulumiTagMarker
public class AgentPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AgentPoolArgs = AgentPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AgentPoolArgsBuilder.() -> Unit) {
        val builder = AgentPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AgentPool {
        val builtJavaResource =
            com.pulumi.azurenative.containerservice.AgentPool(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AgentPool(builtJavaResource)
    }
}

/**
 * Agent Pool.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2019-02-01, 2019-04-01, 2020-06-01, 2021-02-01, 2021-08-01, 2022-04-02-preview, 2023-05-02-preview, 2023-06-01, 2023-06-02-preview, 2023-07-01, 2023-07-02-preview, 2023-08-01, 2023-08-02-preview, 2023-09-01, 2023-09-02-preview, 2023-10-01, 2023-10-02-preview, 2023-11-01, 2023-11-02-preview, 2024-01-01, 2024-01-02-preview, 2024-02-01, 2024-02-02-preview, 2024-03-02-preview.
 * ## Example Usage
 * ### Create Agent Pool using an agent pool snapshot
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         CreationData = new AzureNative.ContainerService.Inputs.CreationDataArgs
 *         {
 *             SourceResourceId = "/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1",
 *         },
 *         EnableFIPS = true,
 *         OrchestratorVersion = "",
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			Count:         pulumi.Int(3),
 * 			CreationData: &containerservice.CreationDataArgs{
 * 				SourceResourceId: pulumi.String("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1"),
 * 			},
 * 			EnableFIPS:          pulumi.Bool(true),
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsType:              pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import com.pulumi.azurenative.containerservice.inputs.CreationDataArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .creationData(CreationDataArgs.builder()
 *                 .sourceResourceId("/subscriptions/subid1/resourceGroups/rg1/providers/Microsoft.ContainerService/snapshots/snapshot1")
 *                 .build())
 *             .enableFIPS(true)
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with Dedicated Host Group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         HostGroupID = "/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1",
 *         OrchestratorVersion = "",
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:       pulumi.String("agentpool1"),
 * 			Count:               pulumi.Int(3),
 * 			HostGroupID:         pulumi.String("/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1"),
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsType:              pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .hostGroupID("/subscriptions/subid1/resourcegroups/rg/providers/Microsoft.Compute/hostGroups/hostgroup1")
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with EncryptionAtHost enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         EnableEncryptionAtHost = true,
 *         OrchestratorVersion = "",
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:          pulumi.String("agentpool1"),
 * 			Count:                  pulumi.Int(3),
 * 			EnableEncryptionAtHost: pulumi.Bool(true),
 * 			OrchestratorVersion:    pulumi.String(""),
 * 			OsType:                 pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			ResourceName:           pulumi.String("clustername1"),
 * 			VmSize:                 pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .enableEncryptionAtHost(true)
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with Ephemeral OS Disk
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         OrchestratorVersion = "",
 *         OsDiskSizeGB = 64,
 *         OsDiskType = AzureNative.ContainerService.OSDiskType.Ephemeral,
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:       pulumi.String("agentpool1"),
 * 			Count:               pulumi.Int(3),
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsDiskSizeGB:        pulumi.Int(64),
 * 			OsDiskType:          pulumi.String(containerservice.OSDiskTypeEphemeral),
 * 			OsType:              pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .orchestratorVersion("")
 *             .osDiskSizeGB(64)
 *             .osDiskType("Ephemeral")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with FIPS enabled OS
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         EnableFIPS = true,
 *         OrchestratorVersion = "",
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:       pulumi.String("agentpool1"),
 * 			Count:               pulumi.Int(3),
 * 			EnableFIPS:          pulumi.Bool(true),
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsType:              pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .enableFIPS(true)
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with GPUMIG
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         GpuInstanceProfile = AzureNative.ContainerService.GPUInstanceProfile.MIG2g,
 *         KubeletConfig = new AzureNative.ContainerService.Inputs.KubeletConfigArgs
 *         {
 *             AllowedUnsafeSysctls = new[]
 *             {
 *                 "kernel.msg*",
 *                 "net.core.somaxconn",
 *             },
 *             CpuCfsQuota = true,
 *             CpuCfsQuotaPeriod = "200ms",
 *             CpuManagerPolicy = "static",
 *             FailSwapOn = false,
 *             ImageGcHighThreshold = 90,
 *             ImageGcLowThreshold = 70,
 *             TopologyManagerPolicy = "best-effort",
 *         },
 *         LinuxOSConfig = new AzureNative.ContainerService.Inputs.LinuxOSConfigArgs
 *         {
 *             SwapFileSizeMB = 1500,
 *             Sysctls = new AzureNative.ContainerService.Inputs.SysctlConfigArgs
 *             {
 *                 KernelThreadsMax = 99999,
 *                 NetCoreWmemDefault = 12345,
 *                 NetIpv4IpLocalPortRange = "20000 60000",
 *                 NetIpv4TcpTwReuse = true,
 *             },
 *             TransparentHugePageDefrag = "madvise",
 *             TransparentHugePageEnabled = "always",
 *         },
 *         OrchestratorVersion = "",
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_ND96asr_v4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:      pulumi.String("agentpool1"),
 * 			Count:              pulumi.Int(3),
 * 			GpuInstanceProfile: pulumi.String(containerservice.GPUInstanceProfileMIG2g),
 * 			KubeletConfig: &containerservice.KubeletConfigArgs{
 * 				AllowedUnsafeSysctls: pulumi.StringArray{
 * 					pulumi.String("kernel.msg*"),
 * 					pulumi.String("net.core.somaxconn"),
 * 				},
 * 				CpuCfsQuota:           pulumi.Bool(true),
 * 				CpuCfsQuotaPeriod:     pulumi.String("200ms"),
 * 				CpuManagerPolicy:      pulumi.String("static"),
 * 				FailSwapOn:            pulumi.Bool(false),
 * 				ImageGcHighThreshold:  pulumi.Int(90),
 * 				ImageGcLowThreshold:   pulumi.Int(70),
 * 				TopologyManagerPolicy: pulumi.String("best-effort"),
 * 			},
 * 			LinuxOSConfig: &containerservice.LinuxOSConfigArgs{
 * 				SwapFileSizeMB: pulumi.Int(1500),
 * 				Sysctls: &containerservice.SysctlConfigArgs{
 * 					KernelThreadsMax:        pulumi.Int(99999),
 * 					NetCoreWmemDefault:      pulumi.Int(12345),
 * 					NetIpv4IpLocalPortRange: pulumi.String("20000 60000"),
 * 					NetIpv4TcpTwReuse:       pulumi.Bool(true),
 * 				},
 * 				TransparentHugePageDefrag:  pulumi.String("madvise"),
 * 				TransparentHugePageEnabled: pulumi.String("always"),
 * 			},
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsType:              pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_ND96asr_v4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import com.pulumi.azurenative.containerservice.inputs.KubeletConfigArgs;
 * import com.pulumi.azurenative.containerservice.inputs.LinuxOSConfigArgs;
 * import com.pulumi.azurenative.containerservice.inputs.SysctlConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .gpuInstanceProfile("MIG2g")
 *             .kubeletConfig(KubeletConfigArgs.builder()
 *                 .allowedUnsafeSysctls(
 *                     "kernel.msg*",
 *                     "net.core.somaxconn")
 *                 .cpuCfsQuota(true)
 *                 .cpuCfsQuotaPeriod("200ms")
 *                 .cpuManagerPolicy("static")
 *                 .failSwapOn(false)
 *                 .imageGcHighThreshold(90)
 *                 .imageGcLowThreshold(70)
 *                 .topologyManagerPolicy("best-effort")
 *                 .build())
 *             .linuxOSConfig(LinuxOSConfigArgs.builder()
 *                 .swapFileSizeMB(1500)
 *                 .sysctls(SysctlConfigArgs.builder()
 *                     .kernelThreadsMax(99999)
 *                     .netCoreWmemDefault(12345)
 *                     .netIpv4IpLocalPortRange("20000 60000")
 *                     .netIpv4TcpTwReuse(true)
 *                     .build())
 *                 .transparentHugePageDefrag("madvise")
 *                 .transparentHugePageEnabled("always")
 *                 .build())
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_ND96asr_v4")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with Krustlet and the WASI runtime
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         Mode = AzureNative.ContainerService.AgentPoolMode.User,
 *         OrchestratorVersion = "",
 *         OsDiskSizeGB = 64,
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *         WorkloadRuntime = AzureNative.ContainerService.WorkloadRuntime.WasmWasi,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:       pulumi.String("agentpool1"),
 * 			Count:               pulumi.Int(3),
 * 			Mode:                pulumi.String(containerservice.AgentPoolModeUser),
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsDiskSizeGB:        pulumi.Int(64),
 * 			OsType:              pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 			WorkloadRuntime:     pulumi.String(containerservice.WorkloadRuntimeWasmWasi),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .mode("User")
 *             .orchestratorVersion("")
 *             .osDiskSizeGB(64)
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .workloadRuntime("WasmWasi")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with KubeletConfig and LinuxOSConfig
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         KubeletConfig = new AzureNative.ContainerService.Inputs.KubeletConfigArgs
 *         {
 *             AllowedUnsafeSysctls = new[]
 *             {
 *                 "kernel.msg*",
 *                 "net.core.somaxconn",
 *             },
 *             CpuCfsQuota = true,
 *             CpuCfsQuotaPeriod = "200ms",
 *             CpuManagerPolicy = "static",
 *             FailSwapOn = false,
 *             ImageGcHighThreshold = 90,
 *             ImageGcLowThreshold = 70,
 *             TopologyManagerPolicy = "best-effort",
 *         },
 *         LinuxOSConfig = new AzureNative.ContainerService.Inputs.LinuxOSConfigArgs
 *         {
 *             SwapFileSizeMB = 1500,
 *             Sysctls = new AzureNative.ContainerService.Inputs.SysctlConfigArgs
 *             {
 *                 KernelThreadsMax = 99999,
 *                 NetCoreWmemDefault = 12345,
 *                 NetIpv4IpLocalPortRange = "20000 60000",
 *                 NetIpv4TcpTwReuse = true,
 *             },
 *             TransparentHugePageDefrag = "madvise",
 *             TransparentHugePageEnabled = "always",
 *         },
 *         OrchestratorVersion = "",
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			Count:         pulumi.Int(3),
 * 			KubeletConfig: &containerservice.KubeletConfigArgs{
 * 				AllowedUnsafeSysctls: pulumi.StringArray{
 * 					pulumi.String("kernel.msg*"),
 * 					pulumi.String("net.core.somaxconn"),
 * 				},
 * 				CpuCfsQuota:           pulumi.Bool(true),
 * 				CpuCfsQuotaPeriod:     pulumi.String("200ms"),
 * 				CpuManagerPolicy:      pulumi.String("static"),
 * 				FailSwapOn:            pulumi.Bool(false),
 * 				ImageGcHighThreshold:  pulumi.Int(90),
 * 				ImageGcLowThreshold:   pulumi.Int(70),
 * 				TopologyManagerPolicy: pulumi.String("best-effort"),
 * 			},
 * 			LinuxOSConfig: &containerservice.LinuxOSConfigArgs{
 * 				SwapFileSizeMB: pulumi.Int(1500),
 * 				Sysctls: &containerservice.SysctlConfigArgs{
 * 					KernelThreadsMax:        pulumi.Int(99999),
 * 					NetCoreWmemDefault:      pulumi.Int(12345),
 * 					NetIpv4IpLocalPortRange: pulumi.String("20000 60000"),
 * 					NetIpv4TcpTwReuse:       pulumi.Bool(true),
 * 				},
 * 				TransparentHugePageDefrag:  pulumi.String("madvise"),
 * 				TransparentHugePageEnabled: pulumi.String("always"),
 * 			},
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsType:              pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import com.pulumi.azurenative.containerservice.inputs.KubeletConfigArgs;
 * import com.pulumi.azurenative.containerservice.inputs.LinuxOSConfigArgs;
 * import com.pulumi.azurenative.containerservice.inputs.SysctlConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .kubeletConfig(KubeletConfigArgs.builder()
 *                 .allowedUnsafeSysctls(
 *                     "kernel.msg*",
 *                     "net.core.somaxconn")
 *                 .cpuCfsQuota(true)
 *                 .cpuCfsQuotaPeriod("200ms")
 *                 .cpuManagerPolicy("static")
 *                 .failSwapOn(false)
 *                 .imageGcHighThreshold(90)
 *                 .imageGcLowThreshold(70)
 *                 .topologyManagerPolicy("best-effort")
 *                 .build())
 *             .linuxOSConfig(LinuxOSConfigArgs.builder()
 *                 .swapFileSizeMB(1500)
 *                 .sysctls(SysctlConfigArgs.builder()
 *                     .kernelThreadsMax(99999)
 *                     .netCoreWmemDefault(12345)
 *                     .netIpv4IpLocalPortRange("20000 60000")
 *                     .netIpv4TcpTwReuse(true)
 *                     .build())
 *                 .transparentHugePageDefrag("madvise")
 *                 .transparentHugePageEnabled("always")
 *                 .build())
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with OSSKU
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         KubeletConfig = new AzureNative.ContainerService.Inputs.KubeletConfigArgs
 *         {
 *             AllowedUnsafeSysctls = new[]
 *             {
 *                 "kernel.msg*",
 *                 "net.core.somaxconn",
 *             },
 *             CpuCfsQuota = true,
 *             CpuCfsQuotaPeriod = "200ms",
 *             CpuManagerPolicy = "static",
 *             FailSwapOn = false,
 *             ImageGcHighThreshold = 90,
 *             ImageGcLowThreshold = 70,
 *             TopologyManagerPolicy = "best-effort",
 *         },
 *         LinuxOSConfig = new AzureNative.ContainerService.Inputs.LinuxOSConfigArgs
 *         {
 *             SwapFileSizeMB = 1500,
 *             Sysctls = new AzureNative.ContainerService.Inputs.SysctlConfigArgs
 *             {
 *                 KernelThreadsMax = 99999,
 *                 NetCoreWmemDefault = 12345,
 *                 NetIpv4IpLocalPortRange = "20000 60000",
 *                 NetIpv4TcpTwReuse = true,
 *             },
 *             TransparentHugePageDefrag = "madvise",
 *             TransparentHugePageEnabled = "always",
 *         },
 *         OrchestratorVersion = "",
 *         OsSKU = AzureNative.ContainerService.OSSKU.AzureLinux,
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			Count:         pulumi.Int(3),
 * 			KubeletConfig: &containerservice.KubeletConfigArgs{
 * 				AllowedUnsafeSysctls: pulumi.StringArray{
 * 					pulumi.String("kernel.msg*"),
 * 					pulumi.String("net.core.somaxconn"),
 * 				},
 * 				CpuCfsQuota:           pulumi.Bool(true),
 * 				CpuCfsQuotaPeriod:     pulumi.String("200ms"),
 * 				CpuManagerPolicy:      pulumi.String("static"),
 * 				FailSwapOn:            pulumi.Bool(false),
 * 				ImageGcHighThreshold:  pulumi.Int(90),
 * 				ImageGcLowThreshold:   pulumi.Int(70),
 * 				TopologyManagerPolicy: pulumi.String("best-effort"),
 * 			},
 * 			LinuxOSConfig: &containerservice.LinuxOSConfigArgs{
 * 				SwapFileSizeMB: pulumi.Int(1500),
 * 				Sysctls: &containerservice.SysctlConfigArgs{
 * 					KernelThreadsMax:        pulumi.Int(99999),
 * 					NetCoreWmemDefault:      pulumi.Int(12345),
 * 					NetIpv4IpLocalPortRange: pulumi.String("20000 60000"),
 * 					NetIpv4TcpTwReuse:       pulumi.Bool(true),
 * 				},
 * 				TransparentHugePageDefrag:  pulumi.String("madvise"),
 * 				TransparentHugePageEnabled: pulumi.String("always"),
 * 			},
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsSKU:               pulumi.String(containerservice.OSSKUAzureLinux),
 * 			OsType:              pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import com.pulumi.azurenative.containerservice.inputs.KubeletConfigArgs;
 * import com.pulumi.azurenative.containerservice.inputs.LinuxOSConfigArgs;
 * import com.pulumi.azurenative.containerservice.inputs.SysctlConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .kubeletConfig(KubeletConfigArgs.builder()
 *                 .allowedUnsafeSysctls(
 *                     "kernel.msg*",
 *                     "net.core.somaxconn")
 *                 .cpuCfsQuota(true)
 *                 .cpuCfsQuotaPeriod("200ms")
 *                 .cpuManagerPolicy("static")
 *                 .failSwapOn(false)
 *                 .imageGcHighThreshold(90)
 *                 .imageGcLowThreshold(70)
 *                 .topologyManagerPolicy("best-effort")
 *                 .build())
 *             .linuxOSConfig(LinuxOSConfigArgs.builder()
 *                 .swapFileSizeMB(1500)
 *                 .sysctls(SysctlConfigArgs.builder()
 *                     .kernelThreadsMax(99999)
 *                     .netCoreWmemDefault(12345)
 *                     .netIpv4IpLocalPortRange("20000 60000")
 *                     .netIpv4TcpTwReuse(true)
 *                     .build())
 *                 .transparentHugePageDefrag("madvise")
 *                 .transparentHugePageEnabled("always")
 *                 .build())
 *             .orchestratorVersion("")
 *             .osSKU("AzureLinux")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with PPG
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         OrchestratorVersion = "",
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ProximityPlacementGroupID = "/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:             pulumi.String("agentpool1"),
 * 			Count:                     pulumi.Int(3),
 * 			OrchestratorVersion:       pulumi.String(""),
 * 			OsType:                    pulumi.String(containerservice.OSTypeLinux),
 * 			ProximityPlacementGroupID: pulumi.String("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1"),
 * 			ResourceGroupName:         pulumi.String("rg1"),
 * 			ResourceName:              pulumi.String("clustername1"),
 * 			VmSize:                    pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .proximityPlacementGroupID("/subscriptions/subid1/resourcegroups/rg1/providers/Microsoft.Compute/proximityPlacementGroups/ppg1")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with UltraSSD enabled
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         EnableUltraSSD = true,
 *         OrchestratorVersion = "",
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_DS2_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:       pulumi.String("agentpool1"),
 * 			Count:               pulumi.Int(3),
 * 			EnableUltraSSD:      pulumi.Bool(true),
 * 			OrchestratorVersion: pulumi.String(""),
 * 			OsType:              pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_DS2_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .enableUltraSSD(true)
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_DS2_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Agent Pool with Windows OSSKU
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "wnp2",
 *         Count = 3,
 *         OrchestratorVersion = "1.23.3",
 *         OsSKU = AzureNative.ContainerService.OSSKU.Windows2022,
 *         OsType = AzureNative.ContainerService.OSType.Windows,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         VmSize = "Standard_D4s_v3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:       pulumi.String("wnp2"),
 * 			Count:               pulumi.Int(3),
 * 			OrchestratorVersion: pulumi.String("1.23.3"),
 * 			OsSKU:               pulumi.String(containerservice.OSSKUWindows2022),
 * 			OsType:              pulumi.String(containerservice.OSTypeWindows),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceName:        pulumi.String("clustername1"),
 * 			VmSize:              pulumi.String("Standard_D4s_v3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("wnp2")
 *             .count(3)
 *             .orchestratorVersion("1.23.3")
 *             .osSKU("Windows2022")
 *             .osType("Windows")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .vmSize("Standard_D4s_v3")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Spot Agent Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         NodeLabels =
 *         {
 *             { "key1", "val1" },
 *         },
 *         NodeTaints = new[]
 *         {
 *             "Key1=Value1:NoSchedule",
 *         },
 *         OrchestratorVersion = "",
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ScaleSetEvictionPolicy = AzureNative.ContainerService.ScaleSetEvictionPolicy.Delete,
 *         ScaleSetPriority = AzureNative.ContainerService.ScaleSetPriority.Spot,
 *         Tags =
 *         {
 *             { "name1", "val1" },
 *         },
 *         VmSize = "Standard_DS1_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			Count:         pulumi.Int(3),
 * 			NodeLabels: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 			},
 * 			NodeTaints: pulumi.StringArray{
 * 				pulumi.String("Key1=Value1:NoSchedule"),
 * 			},
 * 			OrchestratorVersion:    pulumi.String(""),
 * 			OsType:                 pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			ResourceName:           pulumi.String("clustername1"),
 * 			ScaleSetEvictionPolicy: pulumi.String(containerservice.ScaleSetEvictionPolicyDelete),
 * 			ScaleSetPriority:       pulumi.String(containerservice.ScaleSetPrioritySpot),
 * 			Tags: pulumi.StringMap{
 * 				"name1": pulumi.String("val1"),
 * 			},
 * 			VmSize: pulumi.String("Standard_DS1_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .nodeLabels(Map.of("key1", "val1"))
 *             .nodeTaints("Key1=Value1:NoSchedule")
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .scaleSetEvictionPolicy("Delete")
 *             .scaleSetPriority("Spot")
 *             .tags(Map.of("name1", "val1"))
 *             .vmSize("Standard_DS1_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create/Update Agent Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         Mode = AzureNative.ContainerService.AgentPoolMode.User,
 *         NodeLabels =
 *         {
 *             { "key1", "val1" },
 *         },
 *         NodeTaints = new[]
 *         {
 *             "Key1=Value1:NoSchedule",
 *         },
 *         OrchestratorVersion = "",
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ScaleSetEvictionPolicy = AzureNative.ContainerService.ScaleSetEvictionPolicy.Delete,
 *         ScaleSetPriority = AzureNative.ContainerService.ScaleSetPriority.Spot,
 *         Tags =
 *         {
 *             { "name1", "val1" },
 *         },
 *         VmSize = "Standard_DS1_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			Count:         pulumi.Int(3),
 * 			Mode:          pulumi.String(containerservice.AgentPoolModeUser),
 * 			NodeLabels: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 			},
 * 			NodeTaints: pulumi.StringArray{
 * 				pulumi.String("Key1=Value1:NoSchedule"),
 * 			},
 * 			OrchestratorVersion:    pulumi.String(""),
 * 			OsType:                 pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			ResourceName:           pulumi.String("clustername1"),
 * 			ScaleSetEvictionPolicy: pulumi.String(containerservice.ScaleSetEvictionPolicyDelete),
 * 			ScaleSetPriority:       pulumi.String(containerservice.ScaleSetPrioritySpot),
 * 			Tags: pulumi.StringMap{
 * 				"name1": pulumi.String("val1"),
 * 			},
 * 			VmSize: pulumi.String("Standard_DS1_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .mode("User")
 *             .nodeLabels(Map.of("key1", "val1"))
 *             .nodeTaints("Key1=Value1:NoSchedule")
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .scaleSetEvictionPolicy("Delete")
 *             .scaleSetPriority("Spot")
 *             .tags(Map.of("name1", "val1"))
 *             .vmSize("Standard_DS1_v2")
 *             .build());
 *     }
 * }
 * ```
 * ### Start Agent Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         PowerState = new AzureNative.ContainerService.Inputs.PowerStateArgs
 *         {
 *             Code = AzureNative.ContainerService.Code.Running,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			PowerState: &containerservice.PowerStateArgs{
 * 				Code: pulumi.String(containerservice.CodeRunning),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import com.pulumi.azurenative.containerservice.inputs.PowerStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .powerState(PowerStateArgs.builder()
 *                 .code("Running")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .build());
 *     }
 * }
 * ```
 * ### Stop Agent Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         PowerState = new AzureNative.ContainerService.Inputs.PowerStateArgs
 *         {
 *             Code = AzureNative.ContainerService.Code.Stopped,
 *         },
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName: pulumi.String("agentpool1"),
 * 			PowerState: &containerservice.PowerStateArgs{
 * 				Code: pulumi.String(containerservice.CodeStopped),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("clustername1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import com.pulumi.azurenative.containerservice.inputs.PowerStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .powerState(PowerStateArgs.builder()
 *                 .code("Stopped")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .build());
 *     }
 * }
 * ```
 * ### Update Agent Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerService.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "agentpool1",
 *         Count = 3,
 *         EnableAutoScaling = true,
 *         MaxCount = 2,
 *         MinCount = 2,
 *         NodeTaints = new[]
 *         {
 *             "Key1=Value1:NoSchedule",
 *         },
 *         OrchestratorVersion = "",
 *         OsType = AzureNative.ContainerService.OSType.Linux,
 *         ResourceGroupName = "rg1",
 *         ResourceName = "clustername1",
 *         ScaleSetEvictionPolicy = AzureNative.ContainerService.ScaleSetEvictionPolicy.Delete,
 *         ScaleSetPriority = AzureNative.ContainerService.ScaleSetPriority.Spot,
 *         VmSize = "Standard_DS1_v2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerservice.NewAgentPool(ctx, "agentPool", &containerservice.AgentPoolArgs{
 * 			AgentPoolName:     pulumi.String("agentpool1"),
 * 			Count:             pulumi.Int(3),
 * 			EnableAutoScaling: pulumi.Bool(true),
 * 			MaxCount:          pulumi.Int(2),
 * 			MinCount:          pulumi.Int(2),
 * 			NodeTaints: pulumi.StringArray{
 * 				pulumi.String("Key1=Value1:NoSchedule"),
 * 			},
 * 			OrchestratorVersion:    pulumi.String(""),
 * 			OsType:                 pulumi.String(containerservice.OSTypeLinux),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			ResourceName:           pulumi.String("clustername1"),
 * 			ScaleSetEvictionPolicy: pulumi.String(containerservice.ScaleSetEvictionPolicyDelete),
 * 			ScaleSetPriority:       pulumi.String(containerservice.ScaleSetPrioritySpot),
 * 			VmSize:                 pulumi.String("Standard_DS1_v2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerservice.AgentPool;
 * import com.pulumi.azurenative.containerservice.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("agentpool1")
 *             .count(3)
 *             .enableAutoScaling(true)
 *             .maxCount(2)
 *             .minCount(2)
 *             .nodeTaints("Key1=Value1:NoSchedule")
 *             .orchestratorVersion("")
 *             .osType("Linux")
 *             .resourceGroupName("rg1")
 *             .resourceName("clustername1")
 *             .scaleSetEvictionPolicy("Delete")
 *             .scaleSetPriority("Spot")
 *             .vmSize("Standard_DS1_v2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerservice:AgentPool agentpool1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}
 * ```
 */
public class AgentPool internal constructor(
    override val javaResource: com.pulumi.azurenative.containerservice.AgentPool,
) : KotlinCustomResource(javaResource, AgentPoolMapper) {
    /**
     * The list of Availability zones to use for nodes. This can only be specified if the AgentPoolType property is 'VirtualMachineScaleSets'.
     */
    public val availabilityZones: Output<List<String>>?
        get() = javaResource.availabilityZones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Number of agents (VMs) to host docker containers. Allowed values must be in the range of 0 to 1000 (inclusive) for user pools and in the range of 1 to 1000 (inclusive) for system pools. The default value is 1.
     */
    public val count: Output<Int>?
        get() = javaResource.count().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * CreationData to be used to specify the source Snapshot ID if the node pool will be created/upgraded using a snapshot.
     */
    public val creationData: Output<CreationDataResponse>?
        get() = javaResource.creationData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    creationDataResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * If orchestratorVersion is a fully specified version <major.minor.patch>, this field will be exactly equal to it. If orchestratorVersion is <major.minor>, this field will contain the full <major.minor.patch> version being used.
     */
    public val currentOrchestratorVersion: Output<String>
        get() = javaResource.currentOrchestratorVersion().applyValue({ args0 -> args0 })

    /**
     * Whether to enable auto-scaler
     */
    public val enableAutoScaling: Output<Boolean>?
        get() = javaResource.enableAutoScaling().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This is only supported on certain VM sizes and in certain Azure regions. For more information, see: https://docs.microsoft.com/azure/aks/enable-host-encryption
     */
    public val enableEncryptionAtHost: Output<Boolean>?
        get() = javaResource.enableEncryptionAtHost().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * See [Add a FIPS-enabled node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#add-a-fips-enabled-node-pool-preview) for more details.
     */
    public val enableFIPS: Output<Boolean>?
        get() = javaResource.enableFIPS().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Some scenarios may require nodes in a node pool to receive their own dedicated public IP addresses. A common scenario is for gaming workloads, where a console needs to make a direct connection to a cloud virtual machine to minimize hops. For more information see [assigning a public IP per node](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#assign-a-public-ip-per-node-for-your-node-pools). The default is false.
     */
    public val enableNodePublicIP: Output<Boolean>?
        get() = javaResource.enableNodePublicIP().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable UltraSSD
     */
    public val enableUltraSSD: Output<Boolean>?
        get() = javaResource.enableUltraSSD().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * GPUInstanceProfile to be used to specify GPU MIG instance profile for supported GPU VM SKU.
     */
    public val gpuInstanceProfile: Output<String>?
        get() = javaResource.gpuInstanceProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}. For more information see [Azure dedicated hosts](https://docs.microsoft.com/azure/virtual-machines/dedicated-hosts).
     */
    public val hostGroupID: Output<String>?
        get() = javaResource.hostGroupID().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Kubelet configuration on the agent pool nodes.
     */
    public val kubeletConfig: Output<KubeletConfigResponse>?
        get() = javaResource.kubeletConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> kubeletConfigResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Determines the placement of emptyDir volumes, container runtime data root, and Kubelet ephemeral storage.
     */
    public val kubeletDiskType: Output<String>?
        get() = javaResource.kubeletDiskType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The OS configuration of Linux agent nodes.
     */
    public val linuxOSConfig: Output<LinuxOSConfigResponse>?
        get() = javaResource.linuxOSConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> linuxOSConfigResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The maximum number of nodes for auto-scaling
     */
    public val maxCount: Output<Int>?
        get() = javaResource.maxCount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The maximum number of pods that can run on a node.
     */
    public val maxPods: Output<Int>?
        get() = javaResource.maxPods().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The minimum number of nodes for auto-scaling
     */
    public val minCount: Output<Int>?
        get() = javaResource.minCount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A cluster must have at least one 'System' Agent Pool at all times. For additional information on agent pool restrictions and best practices, see: https://docs.microsoft.com/azure/aks/use-system-pools
     */
    public val mode: Output<String>?
        get() = javaResource.mode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The version of node image
     */
    public val nodeImageVersion: Output<String>
        get() = javaResource.nodeImageVersion().applyValue({ args0 -> args0 })

    /**
     * The node labels to be persisted across all nodes in agent pool.
     */
    public val nodeLabels: Output<Map<String, String>>?
        get() = javaResource.nodeLabels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIPPrefixName}
     */
    public val nodePublicIPPrefixID: Output<String>?
        get() = javaResource.nodePublicIPPrefixID().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The taints added to new nodes during node pool create and scale. For example, key=value:NoSchedule.
     */
    public val nodeTaints: Output<List<String>>?
        get() = javaResource.nodeTaints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Both patch version <major.minor.patch> (e.g. 1.20.13) and <major.minor> (e.g. 1.20) are supported. When <major.minor> is specified, the latest supported GA patch version is chosen automatically. Updating the cluster with the same <major.minor> once it has been created (e.g. 1.14.x -> 1.14) will not trigger an upgrade, even if a newer patch version is available. As a best practice, you should upgrade all node pools in an AKS cluster to the same Kubernetes version. The node pool version must have the same major version as the control plane. The node pool minor version must be within two minor versions of the control plane version. The node pool version cannot be greater than the control plane version. For more information see [upgrading a node pool](https://docs.microsoft.com/azure/aks/use-multiple-node-pools#upgrade-a-node-pool).
     */
    public val orchestratorVersion: Output<String>?
        get() = javaResource.orchestratorVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * OS Disk Size in GB to be used to specify the disk size for every machine in the master/agent pool. If you specify 0, it will apply the default osDisk size according to the vmSize specified.
     */
    public val osDiskSizeGB: Output<Int>?
        get() = javaResource.osDiskSizeGB().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The default is 'Ephemeral' if the VM supports it and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults to 'Managed'. May not be changed after creation. For more information see [Ephemeral OS](https://docs.microsoft.com/azure/aks/cluster-configuration#ephemeral-os).
     */
    public val osDiskType: Output<String>?
        get() = javaResource.osDiskType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the OS SKU used by the agent pool. The default is Ubuntu if OSType is Linux. The default is Windows2019 when Kubernetes <= 1.24 or Windows2022 when Kubernetes >= 1.25 if OSType is Windows.
     */
    public val osSKU: Output<String>?
        get() = javaResource.osSKU().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The operating system type. The default is Linux.
     */
    public val osType: Output<String>?
        get() = javaResource.osType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If omitted, pod IPs are statically assigned on the node subnet (see vnetSubnetID for more details). This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
     */
    public val podSubnetID: Output<String>?
        get() = javaResource.podSubnetID().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When an Agent Pool is first created it is initially Running. The Agent Pool can be stopped by setting this field to Stopped. A stopped Agent Pool stops all of its VMs and does not accrue billing charges. An Agent Pool can only be stopped if it is Running and provisioning state is Succeeded
     */
    public val powerState: Output<PowerStateResponse>?
        get() = javaResource.powerState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    powerStateResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The current deployment or provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The ID for Proximity Placement Group.
     */
    public val proximityPlacementGroupID: Output<String>?
        get() = javaResource.proximityPlacementGroupID().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This also effects the cluster autoscaler behavior. If not specified, it defaults to Delete.
     */
    public val scaleDownMode: Output<String>?
        get() = javaResource.scaleDownMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This cannot be specified unless the scaleSetPriority is 'Spot'. If not specified, the default is 'Delete'.
     */
    public val scaleSetEvictionPolicy: Output<String>?
        get() = javaResource.scaleSetEvictionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Virtual Machine Scale Set priority. If not specified, the default is 'Regular'.
     */
    public val scaleSetPriority: Output<String>?
        get() = javaResource.scaleSetPriority().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Possible values are any decimal value greater than zero or -1 which indicates the willingness to pay any on-demand price. For more details on spot pricing, see [spot VMs pricing](https://docs.microsoft.com/azure/virtual-machines/spot-vms#pricing)
     */
    public val spotMaxPrice: Output<Double>?
        get() = javaResource.spotMaxPrice().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The tags to be persisted on the agent pool virtual machine scale set.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Settings for upgrading the agentpool
     */
    public val upgradeSettings: Output<AgentPoolUpgradeSettingsResponse>?
        get() = javaResource.upgradeSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> agentPoolUpgradeSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * VM size availability varies by region. If a node contains insufficient compute resources (memory, cpu, etc) pods might fail to run correctly. For more details on restricted VM sizes, see: https://docs.microsoft.com/azure/aks/quotas-skus-regions
     */
    public val vmSize: Output<String>?
        get() = javaResource.vmSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If this is not specified, a VNET and subnet will be generated and used. If no podSubnetID is specified, this applies to nodes and pods, otherwise it applies to just nodes. This is of the form: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}
     */
    public val vnetSubnetID: Output<String>?
        get() = javaResource.vnetSubnetID().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Determines the type of workload a node can run.
     */
    public val workloadRuntime: Output<String>?
        get() = javaResource.workloadRuntime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AgentPoolMapper : ResourceMapper<AgentPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerservice.AgentPool::class == javaResource::class

    override fun map(javaResource: Resource): AgentPool = AgentPool(
        javaResource as
            com.pulumi.azurenative.containerservice.AgentPool,
    )
}

/**
 * @see [AgentPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AgentPool].
 */
public suspend fun agentPool(name: String, block: suspend AgentPoolResourceBuilder.() -> Unit): AgentPool {
    val builder = AgentPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AgentPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun agentPool(name: String): AgentPool {
    val builder = AgentPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
